/*
 
***************************************************************************
Macro_Scripts File
Author:   Adam Felt
Macro_Scripts that implement some animation specific methods

Revision History
    May 26, 2004 - Adam Felt - Created
    December 14, 2004 - Nicolas Lonard - added ToggleLimits
	
-- MODIFY THIS AT YOUR OWN RISK
***************************************************************************

*/

macroScript DeleteSelectedAnimation
buttontext:~BUTTONTEXT_CAPTION~
category:~CATEGORY_ANIMATION_TOOLS~ 
internalCategory:"Animation Tools" 
tooltip:~DEL_SELECTED_ANIM_TOOLTIP~ 
(
	On isEnabled Return 
	(
		$selection.count != 0 
	)
	
	
	On Execute Do
	(
		maxOps.deleteSelectedAnimation()
	)
)

macroScript OpenReactionManager
	buttontext:~BUTTONTEXT_REACTION_MANAGER~
	category:~OPENREACTIONMANAGER_CATEGORY_ANIM_TOOLS~
	internalCategory:"Animation Tools" 
	toolTip:~OPENREACTIONMANAGER_TOOLTIP~
(
	reactionMgr.openEditor()
)

macroScript OpenAnimationLayers
	buttontext:~BUTTONTEXT_ANIM_LAYERS~
	category:~OPENANIMATIONLAYERS_ANIM_TOOLS~
	internalCategory:"Animation Tools" 
	toolTip:~OPENANIMATIONLAYERS_TOOLTIP~
(
	animLayerManager.showAnimLayersManagerToolbar true	
)

macroScript ToggleLimits
	buttontext:~BUTTONTEXT_TOGGLE_LIMITS~
	category:~TOGGLELIMITS_ANIM_TOOLS~
	internalCategory:"Animation Tools" 
	toolTip:~TOGGLE_LIMITS_TOOLTIP~
(
	Fn toggleAnimLimits anim &limitTab &toggleValue =
	(
		local ILimitControl
		if anim != undefined do
		(
			if (ILimitControl = getInterface anim #limits) != undefined do		
			(
				if toggleValue and anim.IsEnabled() do
				(
					toggleValue = false
				)
				append limitTab anim 
			)
			
			for i = 1 to anim.numsubs do
			(
				toggleAnimLimits (getSubAnim anim i) &limitTab &toggleValue
			) 
		)
	)

	On isEnabled Return 
	(
		$selection.count != 0 
	)
	
	On Execute Do
	(
		local limitTab = #()
		local toggleValue = true
		for s in selection do
		(
			toggleAnimLimits s &limitTab &toggleValue
		)
		for limit in limitTab do 
		(
			limit.SetEnabled toggleValue
		)
	)
)

macroScript TrajectoryToggle
buttontext:~BUTTONTEXT_TRAJECTORYTOGGLE~
category:~CATEGORY_TRAJECTORYTOGGLE~ 
internalCategory:"Animation Tools" 
tooltip:~TRAJECTORYTOGGLE_TOOLTIP~ 
(
	on isChecked Return
	(
		if(maxOps.trajectoryMode == true) then
			return true
		return false
	)
	On isEnabled Return 
	(
		$selection.count != 0 
	)
	On Execute Do
	(
		if(maxOps.trajectoryMode == true) then
			maxOps.trajectoryMode = false
		else
			maxOps.trajectoryMode = true
	)
)


macroScript TrajectoryKeyModeToggle
buttontext:~BUTTONTTEXT_TRAJECTORYKEYMODETOGGLE~
category:~CATEGORY_TRAJECTORYKEYMODETOGGLE~ 
internalCategory:"Animation Tools" 
tooltip:~TRAJECTORYKEYMODETOGGLE_TOOLTIP~ 
(
	On isEnabled Return 
	(
		$selection.count != 0 
	)
		
	On Execute Do
	(
		if(maxOps.trajectoryKeySubMode == true) then
			maxOps.trajectoryKeySubMode = false
		else
			maxOps.trajectoryKeySubMode = true
	)
)

macroScript TrajectoryAddKeyModeToggle
buttontext:~BUTTONTTEXT_TRAJECTORYADDKEYMODETOGGLE~
category:~TRAJECTORYADDKEYMODETOGGLE_ANIM_TOOLS_CATEGORY~ 
internalCategory:"Animation Tools" 
tooltip:~TRAJECTORYADDKEYMODETOGGLE_TOOLTIP~ 
(
	On isEnabled Return 
	(
		$selection.count != 0 
	)
	
	
	On Execute Do
	(
		if(maxOps.trajectoryAddKeyMode == true) then
			maxOps.trajectoryAddKeyMode = false
		else
			maxOps.trajectoryAddKeyMode = true
	)
)

macroScript TrajectoryDeleteKey
buttontext:~BUTTONTEXT_TRAJECTORYDELETEKEY~
category:~TRAJECTORYDELETEKEY_CATEGORY~ 
internalCategory:"Animation Tools" 
tooltip:~TRAJECTORYDELETEKEY_TOOLTIP~ 
(
	On isEnabled Return 
	(
		$selection.count != 0 
	)
	
	
	On Execute Do
	(
		maxOps.deleteSelectedTrajectoryKey()

	)
)



-- END OF FILE

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQB8rhgYvFrMA/gtM/VRWbLxS++qmB/CULGG
-- goPvRWTs5Rj+xJDaAgu2GybISDXFklncq3We3WLZX/WbcS+/39HiJPg+fKxNsZ6W
-- 3GuC9v0e1UT/pzgQ9k2Y2In9bR73dvFqP1R9zgwleUIGPbGVoRM4ZPq8Mm7RA92L
-- K3YAPHtpNXIjigUqgMK6wTpkK/hbLGxq94gPZPL73tATQ9v2arYOkhqLWGpMnnBE
-- PsIOKp2zrP0cdm7z4BJTHhJiqhXzUu1U0BRM6ZDYNXb3O+HZS0h4k2uKyGuQSCtD
-- 4HyUP/6HgqFlLbGoSvLvwO/xFUC2o6lgaxQ8+U0g2wGdacV/AmwO
-- -----END-SIGNATURE-----